import pandas as pd   
import pickle
import matplotlib.pyplot as plt

# Load the dataset
laptops_price = pd.read_csv("laptops_price.csv")

# Get the indices of the powerful laptops
powerful_laptop_indices = powerful_laptops.index
 
# Access the 'Storage' and 'GPU' columns for the powerful laptops using their indices
powerful_laptops_storage_gpu = laptops_price.loc[powerful_laptop_indices, [' Storage', 'GPU']]
 
# Group the powerful laptops by storage and GPU options
storage_gpu_counts = powerful_laptops_storage_gpu.groupby([' Storage', 'GPU']).size().reset_index(name='Count')
 
# Pivot the data to create a stacked bar chart
storage_gpu_pivot = storage_gpu_counts.pivot_table(index=' Storage', columns='GPU', values='Count', fill_value=0)
 
# Create a stacked bar chart comparing storage and GPU options for the selected laptops
ax = storage_gpu_pivot.plot(kind='bar', stacked=True, figsize=(12, 6))
plt.title('Storage and GPU Options for Laptops with Powerful CPU and at least 8GB RAM')
plt.xlabel('Storage')
plt.ylabel('Number of Laptops')
plt.xticks(rotation=45)
plt.legend(title='GPU', bbox_to_anchor=(1.05, 1), loc='upper left')
 
# Annotate the bars with the counts
for p in ax.patches:
    width, height = p.get_width(), p.get_height()
    x, y = p.get_xy()
    ax.annotate(f'{height}', (x + width / 2, y + height / 2), ha='center', va='center')

plt.savefig('./ref_result/bar_chart.png')
plt.show()

print(storage_gpu_pivot)
pickle.dump(storage_gpu_pivot,open("./ref_result/storage_gpu_pivot.pkl","wb"))
